/*-
 * Copyright (c) 2002 Tim J. Robbins
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * Test program for btowc() and wctob() as specified by IEEE Std. 1003.1-2001
 * and ISO/IEC 9899:1999.
 *
 * The function is tested in the "C" and "ja_JP.eucJP" locales.
 */

#include <common.h>

GLOBAL
int test_btowc()
{
	int i;
    char *locale;

	printf("1..2\n");

	/*
	 * C/POSIX locale.
	 */

    locale = setlocale(LC_CTYPE, "C");
    assert(locale != NULL);
    assert(strcmp(locale, "C") == 0);

	assert(btowc(EOF) == WEOF);
	assert(wctob(WEOF) == EOF);
	for (i = 0; i < UCHAR_MAX; i++)
		assert(btowc(i) == (wchar_t)i && i == (int)wctob(i));

#if CRYSTAX_FULL_LOCALES
	/*
	* Japanese (EUC) locale.
	*/

    locale = setlocale(LC_CTYPE, "ja_JP.eucJP");
    assert(locale != NULL);
    assert(strcmp(locale, "ja_JP.eucJP") == 0);
	assert(MB_CUR_MAX > 1);
	assert(btowc('A') == L'A' && wctob(L'A') == 'A');
	assert(btowc(0xa3) == WEOF && wctob(0xa3c1) == EOF);
#endif /* CRYSTAX_FULL_LOCALES */

	printf("ok 1 - btowc()\n");
	printf("ok 2 - wctob()\n");

	return (0);
}
