# Copyright (C) 2010 The Android Open Source Project
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# This script is used to convert a dependency file generated by a cygwin-less
# GCC compiler program into something that can be parsed into a cygwin-based
# GNU Make program.
#
# More specifically, it's going to translate stuff like:
#
# D:/Stuff/source.o: \
#  D:/Stuff/source.h \
#  C:/NDK/sysroot/include/string.h \
#  C:/NDK/sysroot/include/malloc.h
#
# into
#
# /cygdrive/d/Stuff/source.o: \
#  /cygdrive/d/Stuff/source.h \
#  /cygdrive/c/NDK/sysroot/include/string.h \
#  /cygdrive/c/NDK/sysroot/include/malloc.h
#

BEGIN {
    # TODO: We could determine this dynamically before calling this script
    CYGDRIVE_PREFIX = "/cygdrive/"
}

{
    LINE=""
    SEP=""
    for (nn = 1; nn <= NF; nn++) {
        if ($nn ~ /^[A-Za-z]:/) {
            LINE = LINE SEP CYGDRIVE_PREFIX tolower(substr($nn,1,1)) "/" substr($nn,4)
        } else {
            LINE = LINE SEP $nn
        }
        SEP=" "
    }
    # Any leading space on the original line should be preserved
    MARGIN=""
    if (match($0,"^[[:space:]]+")) {
        MARGIN=substr($0,RSTART,RLENGTH)
    }
    printf("%s%s\n", MARGIN, LINE)
}
